<?php



header("Access-Control-Allow-Origin: *");

require APPPATH . 'libraries/REST_Controller.php';

header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Autorization");

header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");

defined('BASEPATH') OR exit('No direct script access allowed');

ini_set("memory_limit", "-1");

set_time_limit(1000);



class NTC4231 extends REST_Controller {



    public function __construct() {

        parent::__construct();

        $method = $_SERVER['REQUEST_METHOD'];

        if ($method == "OPTIONS") {

            die();

        }

        $this->load->helper(['jwt', 'authorization']);

        $this->load->model("Mntc4231");

        $this->load->dbforge();

        //$this->load->library('Opensslencryptdecrypt');

    }



    public function index_post() {

        date_default_timezone_set('America/bogota');

        $rta = $this->verify_request();



        if ($rta == parent::HTTP_OK) {

            $data = json_decode(file_get_contents("php://input"));

            echo json_encode($data);

            $function = $data->function;

            switch ($function) {

                case 'saveDatos':

                    $rta = $this->saveDatos($data->informe);

                    echo json_encode(1);

                    break;

                default:

                    break;

            }

        }

    }



    function saveDatos($informe) {

        //$informe = $this->input->post('informe');

        $rta = $this->Mntc4231->saveNtc4231($informe);

        return $rta;

    }



    public function index_get() {

        date_default_timezone_set('America/bogota');

        $rta = $this->verify_request();

        if ($rta == parent::HTTP_OK) {

            //$data = json_decode(file_get_contents("php://input"));

            $rta = $this->Mntc4231->getInformeFecha($_GET["fechaInicio"],$_GET["fechaFin"]);

            echo json_encode($rta);

        }

    }

    



    protected function verify_request() {

        $headers = $this->input->request_headers();

        $token = $headers['Autorization'];

        

        try {

            $data = AUTHORIZATION::validateToken($token);

            if ($data === false) {

                $status = parent::HTTP_UNAUTHORIZED;

                $response = ['status' => $status, 'msg' => 'Acceso no autorizado'];

                $this->response($response, $status);

                exit();

            } else {

                return parent::HTTP_OK;

            }

        } catch (Exception $e) {

            $status = parent::HTTP_UNAUTHORIZED;

            $response = ['status' => $status, 'msg' => 'Acceso no autorizado'];

            $this->response($response, $status);

        }

    }



}

